﻿/*
VERSION:		1.0

WHAT THIS DOES:
	This loads & displays an image over the screen.
	The image emerges from a specified point.
	A "Ken Burns" style scrolling is optional.
	Without scrolling, the full image is shown.

PARAMETERS:
	fileName	string		path			The path & filename of the picture to load.
	x				number		pixel			The horizontal location to emerge from.
	y				number		pixel			The vertical location to emerge from.
	scroll			string		direction	The direction to scroll the image:		"up", "down", "left", or "right"
	time			number		seconds		How long the scrolling will take.
*/



showImage = function( fileName, x, y, scroll, time )
{
	if (!ZigoEngine)
	{
		import com.mosesSupposes.fuse.*;
		ZigoEngine.simpleSetup(Shortcuts, PennerEasing);
	}

	time = (time != undefined) ? time : 8;
	var size = (Stage.height * 0.8) / 2;
	var _this = this.createEmptyMovieClip("container_mc", 0);
	_this._x = x;
	_this._y = y;
	_this._scale = 10;
	
	// create mask
	var mask_mc = _this.createEmptyMovieClip("mask_mc", 1);
	mask_mc.beginFill(0xffffff);				// start
	mask_mc.moveTo( -size, -size );		// top-left
	mask_mc.lineTo( size, -size );			// right
	mask_mc.lineTo( size, size );			// down
	mask_mc.lineTo( -size, size );			// left
	mask_mc.lineTo( -size, -size );		// up
	mask_mc.endFill();							// end
	
	var image_mc = _this.createEmptyMovieClip("image_mc", 0);
	var loader = _this.imageLoader = new MovieClipLoader();
	loader.addListener(_this);		// Tell _this when you are done loading.
	loader.loadClip( fileName , image_mc );
	//image_mc.loadMovie("images/misty.jpg");
	
	
	
	_this.emerge = function()
	{
		image_mc._x = -size;
		image_mc._y = -size;
		image_mc._brightness = 100;
		
		if (scroll == undefined)
		{	// resize mask, then reveal
			var nextStep = _this.reSize;
		}
		else
		{	// just reveal
			var nextStep = _this.animate;
		}
		
		// mask grows & centers
		var centerX = Stage.width / 2;
		var centerY = Stage.height / 2;
		//_this.slideTo(centerX, centerY, 0.5, "easeInQuad", 0, nextStep );
		//_this.scaleTo( 100, 0.5, "easeInOutQuad" );
		_this.slideTo(centerX, centerY, 0.25, "linear", 0, nextStep );
		_this.scaleTo( 100, 0.25, "linear" );
	}// emerge()
	
	
	
	_this.fitToWidth = function()
	{
		var maskWidth = mask_mc._width;
		var imageWidth = image_mc._width;
		var newScale = maskWidth * 100 / imageWidth;
		image_mc._scale = newScale;
	}// fitToWidth()
	
	
	
	_this.fitToHeight = function()
	{
		var maskHeight = mask_mc._height;
		var imageHeight = image_mc._height;
		var newScale = maskHeight * 100 / imageHeight;
		image_mc._scale = newScale;
	}// fitToHeight()
	
	
		
	_this.reSize = function()
	{
		// Resize to show the full image
		var imageWidth = image_mc._width;
		var imageHeight = image_mc._height;
		if (imageWidth > imageHeight)
		{// landscape		(fit to width)
			_this.fitToWidth();
		}// landscape
		else
		{// portrait			(fit to height)
			_this.fitToHeight();
		}// portrait
		
		// center image
		var imageWidth = image_mc._width;		// update to new width & height
		var imageHeight = image_mc._height;
		image_mc._x = -( imageWidth/2 );
		image_mc._y = -( imageHeight/2 );
		
		// shape the mask to the image area	(temporarily)
		import mx.transitions.Tween;
		new Tween( mask_mc, "_height", mx.transitions.easing.None.easeNone, mask_mc._height, imageHeight, 0.2, true);
		new Tween( mask_mc, "_width", mx.transitions.easing.None.easeNone, mask_mc._width, imageWidth, 0.2, true);
		setInterval( _this.animate, 200 );
	}// resize
	
	
	
	_this.animate = function()
	{
		image_mc.setMask(mask_mc);
		image_mc._alpha = 100;
		
		// resize image for "ken burns" animation
		// // fit to width
		if(scroll == "up"  || scroll == "down")
		{
			_this.fitToWidth();
		}// up or down
		
		// // fit to height
		if(scroll == "left"  || scroll == "right")
		{
			_this.fitToHeight();
		}// left or right
		
		
		
		// reveal image
		image_mc._quality = "BEST";			// doesn't seem to have any effect
		image_mc.brightnessTo(0, 0.5, "linear");
		
		
		
		// animate "ken burns" effect
		if(scroll == "up")
		{
			// bottom		(offset downward)
			var offset = -size;		// shift up to fill the mask
			var imageHeight = image_mc._height;
			var maskHeight = mask_mc._height;
			offset -= imageHeight - maskHeight;		// subtract to the bottom, then add the mask
			image_mc._y = offset;
			
			// top			(offset downward)
			var offset = -size;
			
			// animate
			image_mc.slideTo( null, offset, time, "easeOutCubic" );
			//image_mc.slideTo( null, -size, 10, "easeOutExpo" );
		}// up
		
		if(scroll == "down")
		{
			// top			(offset downward)
			var offset = -size;		// shift up to fill the mask
			image_mc._y = offset;
			
			// bottom		(offset downward)
			var offset = -size;		// shift up to fill the mask
			var imageHeight = image_mc._height;
			var maskHeight = mask_mc._height;
			offset -= imageHeight - maskHeight;		// subtract to the bottom, then add the mask
			
			// animate
			image_mc.slideTo( null, offset, time, "easeOutCubic" );
			//image_mc.slideTo( null, -size, 10, "easeOutExpo" );
		}// down
		
		if(scroll == "left")
		{
			// right		(offset rightward)
			var offset = -size;		// shift up to fill the mask
			var imageWidth = image_mc._width;
			var maskWidth = mask_mc._width;
			offset -= imageWidth - maskWidth;		// subtract to the right, then add the mask
			image_mc._x = offset;
			
			// left			(offset rightward)
			var offset = -size;
			
			// animate
			image_mc.slideTo( offset, null, time, "easeOutCubic" );
			//image_mc.slideTo( null, -size, 10, "easeOutExpo" );
		}// left
		
		if(scroll == "right")
		{
			// left			(offset rightward)
			var offset = -size;		// shift up to fill the mask
			image_mc._x = offset;
			
			// right			(offset rightward)
			var offset = -size;		// shift up to fill the mask
			var imageWidth = image_mc._width;
			var maskWidth = mask_mc._width;
			offset -= imageWidth - maskWidth;		// subtract to the bottom, then add the mask
			
			// animate
			image_mc.slideTo( offset, null, time, "easeOutCubic" );
			//image_mc.slideTo( null, -size, 10, "easeOutExpo" );
		}// right
	}// animate()
	
	
	
	// when it's done loading the picture
	_this.onLoadInit = function()
	{// done loading image ()
		image_mc._alpha = 0;
		// transition
		_this.emerge();
	}// done loading image ()
}// showImage()